/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.SonarLintWrappedException;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalUpdateRequiredException;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalUpdateStatus;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleUpdateStatus;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.StateListener;
import org.sonarsource.sonarlint.core.client.api.connected.ValidationResult;
import org.sonarsource.sonarlint.core.container.connected.ConnectedContainer;
import org.sonarsource.sonarlint.core.container.storage.StorageGlobalContainer;
import org.sonarsource.sonarlint.core.log.SonarLintLogging;

public final class ConnectedSonarLintEngineImpl
implements ConnectedSonarLintEngine {
    private final ConnectedGlobalConfiguration globalConfig;
    private StorageGlobalContainer globalContainer;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final List<StateListener> listeners = new CopyOnWriteArrayList<StateListener>();
    private ConnectedSonarLintEngine.State state = ConnectedSonarLintEngine.State.UNKNOW;
    private LogOutput logOutput = null;

    public ConnectedSonarLintEngineImpl(ConnectedGlobalConfiguration globalConfig) {
        this.globalConfig = globalConfig;
        this.logOutput = globalConfig.getLogOutput();
        this.start();
    }

    public ConnectedSonarLintEngine.State getState() {
        return this.state;
    }

    public void addStateListener(StateListener listener) {
        this.listeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this.listeners.remove(listener);
    }

    private void changeState(ConnectedSonarLintEngine.State state) {
        this.state = state;
        for (StateListener listener : this.listeners) {
            listener.stateChanged(state);
        }
    }

    public StorageGlobalContainer getGlobalContainer() {
        if (this.globalContainer == null) {
            throw new IllegalStateException("SonarLint Engine for server '" + this.globalConfig.getServerId() + "' is stopped.");
        }
        return this.globalContainer;
    }

    public void start() {
        this.setLogging(null);
        this.rwl.writeLock().lock();
        this.globalContainer = StorageGlobalContainer.create(this.globalConfig);
        try {
            this.globalContainer.startComponents();
            this.changeState(this.globalContainer.getUpdateStatus() != null ? ConnectedSonarLintEngine.State.UPDATED : ConnectedSonarLintEngine.State.NEVER_UPDATED);
        }
        catch (RuntimeException e) {
            this.changeState(ConnectedSonarLintEngine.State.UNKNOW);
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public RuleDetails getRuleDetails(String ruleKey) {
        this.setLogging(null);
        this.rwl.readLock().lock();
        try {
            this.checkUpdateStatus();
            RuleDetails ruleDetails = this.getGlobalContainer().getRuleDetails(ruleKey);
            return ruleDetails;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private void setLogging(@Nullable LogOutput logOutput) {
        if (logOutput != null) {
            SonarLintLogging.set(logOutput);
        } else {
            SonarLintLogging.set(this.logOutput);
        }
    }

    public AnalysisResults analyze(ConnectedAnalysisConfiguration configuration, IssueListener issueListener) {
        return this.analyze(configuration, issueListener, null);
    }

    public AnalysisResults analyze(ConnectedAnalysisConfiguration configuration, IssueListener issueListener, @Nullable LogOutput logOutput) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(issueListener);
        this.setLogging(logOutput);
        this.rwl.readLock().lock();
        try {
            this.checkUpdateStatus();
            AnalysisResults analysisResults = this.getGlobalContainer().analyze(configuration, issueListener);
            return analysisResults;
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public GlobalUpdateStatus getUpdateStatus() {
        this.setLogging(null);
        this.rwl.readLock().lock();
        try {
            GlobalUpdateStatus globalUpdateStatus = this.getGlobalContainer().getUpdateStatus();
            return globalUpdateStatus;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalUpdateStatus update(ServerConfiguration serverConfig) {
        Preconditions.checkNotNull(serverConfig);
        this.setLogging(null);
        this.rwl.writeLock().lock();
        this.stop(false);
        this.changeState(ConnectedSonarLintEngine.State.UPDATING);
        ConnectedContainer connectedContainer = new ConnectedContainer(this.globalConfig, serverConfig);
        try {
            try {
                connectedContainer.startComponents();
                connectedContainer.update();
            }
            catch (RuntimeException e) {
                throw SonarLintWrappedException.wrap((Throwable)e);
            }
            finally {
                try {
                    connectedContainer.stopComponents(false);
                }
                catch (Exception exception) {}
                this.start();
            }
            GlobalUpdateStatus globalUpdateStatus = this.getGlobalContainer().getUpdateStatus();
            return globalUpdateStatus;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public ValidationResult validateConnection(ServerConfiguration serverConfig) {
        Preconditions.checkNotNull(serverConfig);
        this.setLogging(null);
        this.rwl.readLock().lock();
        ConnectedContainer connectedContainer = new ConnectedContainer(this.globalConfig, serverConfig);
        try {
            connectedContainer.startComponents();
            ValidationResult validationResult = connectedContainer.validateConnection();
            return validationResult;
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            try {
                connectedContainer.stopComponents(false);
            }
            catch (Exception exception) {}
            this.rwl.readLock().unlock();
        }
    }

    public Map<String, RemoteModule> allModulesByKey() {
        this.setLogging(null);
        this.rwl.readLock().lock();
        try {
            this.checkUpdateStatus();
            Map<String, RemoteModule> map = this.getGlobalContainer().allModulesByKey();
            return map;
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private void checkUpdateStatus() {
        if (this.state != ConnectedSonarLintEngine.State.UPDATED) {
            throw new GlobalUpdateRequiredException("Please update server '" + this.globalConfig.getServerId() + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateModule(ServerConfiguration serverConfig, String moduleKey) {
        Preconditions.checkNotNull(serverConfig);
        Preconditions.checkNotNull(moduleKey);
        this.setLogging(null);
        this.rwl.writeLock().lock();
        this.checkUpdateStatus();
        ConnectedContainer connectedContainer = new ConnectedContainer(this.globalConfig, serverConfig);
        try {
            this.changeState(ConnectedSonarLintEngine.State.UPDATING);
            connectedContainer.startComponents();
            connectedContainer.updateModule(moduleKey);
        }
        catch (RuntimeException e) {
            try {
                throw SonarLintWrappedException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    connectedContainer.stopComponents(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.changeState(this.getGlobalContainer().getUpdateStatus() != null ? ConnectedSonarLintEngine.State.UPDATED : ConnectedSonarLintEngine.State.NEVER_UPDATED);
                this.rwl.writeLock().unlock();
                throw throwable;
            }
        }
        try {
            connectedContainer.stopComponents(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changeState(this.getGlobalContainer().getUpdateStatus() != null ? ConnectedSonarLintEngine.State.UPDATED : ConnectedSonarLintEngine.State.NEVER_UPDATED);
        this.rwl.writeLock().unlock();
    }

    public ModuleUpdateStatus getModuleUpdateStatus(String moduleKey) {
        Preconditions.checkNotNull(moduleKey);
        this.setLogging(null);
        this.rwl.readLock().lock();
        try {
            ModuleUpdateStatus moduleUpdateStatus = this.getGlobalContainer().getModuleUpdateStatus(moduleKey);
            return moduleUpdateStatus;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public void stop(boolean deleteStorage) {
        this.setLogging(null);
        this.rwl.writeLock().lock();
        try {
            if (this.globalContainer == null) {
                return;
            }
            if (deleteStorage) {
                this.globalContainer.deleteStorage();
            }
            this.globalContainer.stopComponents(false);
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.globalContainer = null;
            this.changeState(ConnectedSonarLintEngine.State.UNKNOW);
            this.rwl.writeLock().unlock();
        }
    }
}

